"use strict";
// import multer from 'multer';
// import expFil from 'express-fileupload'
Object.defineProperty(exports, "__esModule", { value: true });
exports.cleanupTempFiles = exports.moveFilesOutOfTempFolder = exports.fileUploadErrorHandler = exports.multerUpload = void 0;
const tslib_1 = require("tslib");
// const storage = multer.memoryStorage()
// export const multerUpload = multer({ 
//     storage: storage,
//     // limits: {
//     //     fileSize: 10 * 1024 * 1024, // Limit file size to 10MB
//     //     fieldSize: 2 * 1024 * 1024  // Limit non-file field size to 2MB
//     // }
// });
// // export const expressUpload = 
///////////////////////////////////////////////////////////////////
const multer_1 = tslib_1.__importDefault(require("multer"));
const path_1 = tslib_1.__importDefault(require("path"));
const uuid_1 = require("uuid");
const promises_1 = tslib_1.__importDefault(require("fs/promises"));
// // Define allowed file types
// const allowedFileTypes = ['application/pdf', 'image/jpeg', 'image/png'];
// // const storage = multer.memoryStorage();
// const storage = multer.diskStorage({
//   destination: (req, file, cb) => {
//     // Generate a temporary directory based on a unique identifier
//     const tempFolder = uuidv4();
//     const uploadDir = path.join(process.env.UPLOAD_PATH ?? 'public/uploads', 'temp', tempFolder);
//     // Ensure that the directory exists
//     fs.mkdirSync(uploadDir, { recursive: true }); // Recursively create the directory if it doesn't exist
//     // Attach the temporary folder path to the request for further use
//     req.body.tempUploadDir = uploadDir;
//     cb(null, uploadDir); // Pass the directory to multer
//   },
//   filename: (req, file, cb) => {
//     const uniqueName = `${Date.now()}-${file.fieldname}`;
//     cb(null, uniqueName); // You can use any naming strategy here
//   }
// });
// // Define the fileFilter function to check file type
// const fileFilter = (req: any, file: any, cb: any) => {
//   if (allowedFileTypes.includes(file.mimetype)) {
//     cb(null, true);
//   } else {
//     cb(new Error('Invalid file type. Only PDF, JPEG, and PNG are allowed.'), false);
//   }
// };
// export const multerUpload = multer({
//   storage: storage,
//   limits: {
//     fileSize: 500 * 1024 // Limit file size to 500KB
//   },
//   fileFilter: fileFilter
// });
// // Custom error handling middleware for file size
// export const fileUploadErrorHandler = (err: any, req: Request, res: Response, next: NextFunction) => {
//   // Log the error for debugging
//   console.error(err, 'INSIDE multer file');
//   // Handle Multer's specific errors
//   if (err instanceof multer.MulterError) {
//     switch (err.code) {
//       case 'LIMIT_FILE_SIZE':
//         console.log('herf')
//         return res.status(400).json({ error: `File size exceeds the 500KB limit at ${err.field}`, message: `File size exceeds the 500KB limit at ${err.field}` });
//       default:
//         return res.status(400).json({ error: `Multer error: ${err.message}`, message: err.message });
//     }
//   }
//   // Handle other types of errors (e.g., invalid file type)
//   if (err.message) {
//     return res.status(400).json({ error: err.message, message: err.message });
//   }
//   // If the error is unhandled, pass it to the next error handler
//   next(err);
// };
// export const moveFilesToUserFolder = (userId: number, tempDir: string) => {
//   const userDir = path.join(process.env.UPLOAD_PATH ?? 'public/uploads', userId.toString());
//   // Create the user directory if it doesn't exist
//   if (!fs.existsSync(userDir)) {
//     fs.mkdirSync(userDir, { recursive: true });
//   }
//   // Move files from temporary to user directory
//   fs.readdirSync(tempDir).forEach(file => {
//     fs.renameSync(path.join(tempDir, file), path.join(userDir, file));
//   });
//   // Delete the temporary directory
//   console.log('DELETING TEMP after being successful')
//   fs.rmdirSync(tempDir, { recursive: true });
// };
// export const cleanupTempFiles = (tempDir: string) => {
//   console.log('DELETING TEMP')
//   if (fs.existsSync(tempDir)) {
//     // Delete each file in the directory
//     fs.readdirSync(tempDir).forEach(file => {
//       fs.unlinkSync(path.join(tempDir, file));
//     });
//     // Delete the temporary folder
//     fs.rmdirSync(tempDir, { recursive: true });
//   }
// };
const allowedFileTypes = ['application/pdf', 'image/jpeg', 'image/png'];
const directoryExists = (dir) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    try {
        yield promises_1.default.access(dir);
        return true;
    }
    catch (_a) {
        return false;
    }
});
// const storage = multer.diskStorage({
//   destination: async (req, file, cb) => {
//     const tempFolder = uuidv4();
//     const uploadDir = path.join(process.env.UPLOAD_PATH ?? 'public/uploads', 'temp', tempFolder);
//     // Create the temp directory
//     await fsPromises.mkdir(uploadDir, { recursive: true });
//     // Attach the directory to req for later use
//     req.body.tempUploadDir = uploadDir;
//     cb(null, uploadDir);
//   },
//   filename: (req, file, cb) => {
//     const uniqueName = `${Date.now()}-${file.fieldname}`;
//     cb(null, uniqueName);
//   }
// });
const storage = multer_1.default.diskStorage({
    destination: (req, file, cb) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        var _b;
        if (req.body.uploadDir) {
            cb(null, req.body.uploadDir);
        }
        else {
            const tempFolder = (0, uuid_1.v4)();
            const uploadDir = path_1.default.join((_b = process.env.UPLOAD_PATH) !== null && _b !== void 0 ? _b : 'public/uploads', 'temp', tempFolder);
            // Create the temp directory
            yield promises_1.default.mkdir(uploadDir, { recursive: true });
            // Attach the directory to req for later use
            req.body.tempUploadDir = uploadDir;
            cb(null, uploadDir);
        }
    }),
    filename: (req, file, cb) => {
        const uniqueName = `${Date.now()}-${file.fieldname}`;
        cb(null, uniqueName);
    }
});
const fileFilter = (req, file, cb) => {
    if (allowedFileTypes.includes(file.mimetype)) {
        cb(null, true);
    }
    else {
        cb(new Error('Invalid file type. Only PDF, JPEG, and PNG are allowed.'), false);
    }
};
exports.multerUpload = (0, multer_1.default)({
    storage: storage,
    limits: {
        fileSize: 500 * 1024 // Limit file size to 500KB
    },
    fileFilter: fileFilter
});
const fileUploadErrorHandler = (err, req, res, next) => {
    // Log the error for debugging
    console.error(err, 'INSIDE multer file');
    // Handle Multer's specific errors
    if (err instanceof multer_1.default.MulterError) {
        switch (err.code) {
            case 'LIMIT_FILE_SIZE':
                console.log('herf');
                return res.status(400).json({ error: `File size exceeds the 500KB limit at ${err.field}`, message: `File size exceeds the 500KB limit at ${err.field}` });
            default:
                return res.status(400).json({ error: `Multer error: ${err.message}`, message: err.message });
        }
    }
    // Handle other types of errors (e.g., invalid file type)
    if (err.message) {
        return res.status(400).json({ error: err.message, message: err.message });
    }
    // If the error is unhandled, pass it to the next error handler
    next(err);
};
exports.fileUploadErrorHandler = fileUploadErrorHandler;
// Function to move files to a user-specific folder
// export const moveFilesToUserFolder = async (userId: number, tempDir: string) => {
//   const userDir = path.join(process.env.UPLOAD_PATH ?? 'public/uploads', userId.toString());
//   // Create the user directory if it doesn't exist
//   await fsPromises.mkdir(userDir, { recursive: true });
//   const files = await fsPromises.readdir(tempDir);
//   await Promise.all(
//     files.map(file => fsPromises.rename(path.join(tempDir, file), path.join(userDir, file)))
//   );
//   // Clean up the temporary directory after files are moved
//   await cleanupTempFiles(tempDir);
// };
// Function to move files out of the temp folder
const moveFilesOutOfTempFolder = (tempDir) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    // Determine the new location for the files by removing the `temp` segment from the path
    const targetDir = tempDir.replace(/\/temp\//, '/');
    // Create the target directory if it doesn't exist
    yield promises_1.default.mkdir(targetDir, { recursive: true });
    // Read files in the temporary directory
    const files = yield promises_1.default.readdir(tempDir);
    // Move each file from tempDir to targetDir
    yield Promise.all(files.map(file => promises_1.default.rename(path_1.default.join(tempDir, file), path_1.default.join(targetDir, file))));
    // Clean up the temporary directory after files are moved
    yield (0, exports.cleanupTempFiles)(tempDir);
});
exports.moveFilesOutOfTempFolder = moveFilesOutOfTempFolder;
// Function to delete temporary files
const cleanupTempFiles = (tempDir) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    if (yield directoryExists(tempDir)) {
        const files = yield promises_1.default.readdir(tempDir);
        yield Promise.all(files.map(file => promises_1.default.unlink(path_1.default.join(tempDir, file))));
        yield promises_1.default.rmdir(tempDir); // Remove the empty folder
    }
});
exports.cleanupTempFiles = cleanupTempFiles;
